% file fol6e-leq.p: every solution to the N queens problem has a symmetric solution
% (inspired by the TPTP problem PUZ133+2)
% solution with "zero" "succ" "plus" "minus" and "leq", run "vampire --mode casc fol6e-leq.p"

% goal: "p is a solution /\ q is symmetric to p => q is a solution"
fof(goal, conjecture, (queens_p & symmetric_pq) => queens_q).
 
% p and q are solutions to the N queens problem
fof(queens_p, axiom, queens_p <=> 
  ![I,J]:((leq(succ(zero),I) & leq(succ(I),J) & leq(J,n)) => 
    (p(I) != p(J) & plus(p(I),I) != plus(p(J),J) & minus(p(I),I) != minus(p(J),J)))).
fof(queens_q, axiom, queens_q <=> 
  ![I,J]:((leq(succ(zero),I) & leq(succ(I),J) & leq(J,n)) => 
    (q(I) != q(J) & plus(q(I),I) != plus(q(J),J) & minus(q(I),I) != minus(q(J),J)))).

% q is symmetric to p: q(i) = p(pos(i)) = p(n+1-i)
fof(symmetric, axiom, symmetric_pq <=>
  ![I]:((leq(succ(zero),I) & leq(I,n)) => q(I)=p(pos(I)))).
% the definition of pos is actually not helpful, the properties below are required
% fof(symmetric, axiom, pos <=> ![I]:(pos(I) = minus(succ(n),I))).
  
% property required from minus: i+j = k+l <=> i-k = l-j
fof(plus_minus, axiom, ![I,J,K,L]:(plus(I,J) = plus(K,L) <=> minus(I,K) = minus(L,J))).

% properties required from leq: i <= i+1 and (i <= j & j <= k => i <= k)
fof(le_succ, axiom, ![I]:(leq(I,succ(I)))).
fof(le_tran, axiom, ![I,J,K]:((leq(I,J) & leq(J,K)) => leq(I,K))).

% properties required from pos
fof(pos1, axiom, % 1 <= i & i <= n => 1 <= pos(i) & pos(i) <= n
  ![I]:((leq(succ(zero),I) & leq(I,n)) => (leq(succ(zero),pos(I)) & leq(pos(I),n)))).
fof(pos2, axiom, % i-j = pos(j)-pos(i)
  ![J,I]:(minus(I,J) = minus(pos(J),pos(I)))).
fof(pos3, axiom, % 1 <= i & i < j & j <= n => pos(j) < pos(i)
  ![J,I]:((leq(succ(zero),I) & leq(succ(I),J) & leq(J,n)) => leq(succ(pos(J)),pos(I)))).
