% file fol6e-minus.p: every solution to the N queens problem has a symmetric solution
% (inspired by the TPTP problem PUZ133+2)
% solution with "succ" "plus" and "minus", run "vampire fol6e-minus.p"

% goal: "p is a solution /\ q is symmetric to p => q is a solution"
fof(goal, conjecture, (queens_p & symmetric_pq) => queens_q).
   
% p and q are solutions to the N queens problem
fof(queens_p, axiom, queens_p <=> 
  ![I,J]:((p(I) != p(J) & plus(p(I),I) != plus(p(J),J) & minus(p(I),I) != minus(p(J),J)))).
fof(queens_q, axiom, queens_q <=> 
  ![I,J]:((q(I) != q(J) & plus(q(I),I) != plus(q(J),J) & minus(q(I),I) != minus(q(J),J)))).

% definition of the index mapping: p(i)=q(n+1-i)
fof(symmetric, axiom, symmetric_pq <=>
  ![I]:(q(I) = p(minus(succ(n),I)))).

% property required from minus: i+j = k+l <=> i-k = l-j
fof(plus_minus, axiom, ![I,J,K,L]:(plus(I,J) = plus(K,L) <=> minus(I,K) = minus(L,J))).
