let fa0 x y z s c s0 c0 c1 =
  And(And(ha x y s0 c0,ha s0 z s c1),Iff(c,Or(c0,c1)));;

let p(x) = Atom(P(x));;

let adder1 = fa0 (p "A") (p "B") (p "C_in") (p "S") (p "C_out") 
                 (p "S0") (p "C0") (p "C1");;
               
let adder2 = fa (p "A") (p "B") (p "C_in") (p "S") (p "C_out");;

tautology(Imp(adder1,adder2));;

let [x; y; out; c] = map mk_index ["A"; "B"; "S"; "C"];;
ripplecarry x y c out 2;;

let [x; y; z; xy; yz; xyz1; xyz2; cxy; cyz; cxyz1; cxyz2] = 
  map mk_index ["X"; "Y"; "Z"; 
                "XY";  "YZ";  "XYZ1";  "XYZ2"; 
                "CXY"; "CYZ"; "CXYZ1"; "CXYZ2"];;

let bvsize = 2;;
              
let addxy   = ripplecarry x  y  cxy   xy   bvsize;;
let addxyz1 = ripplecarry xy z  cxyz1 xyz1 bvsize;;
let adder1 = And(addxy,addxyz1);;
let addyz   = ripplecarry y  z  cyz   yz   bvsize;;
let addxyz2 = ripplecarry x  yz cxyz2 xyz2 bvsize;;
let adder2 = And(addyz,addxyz2);;

let pvar x i = p(x^"_"^(string_of_int i));;
let rec allequal x y i =
  if i = 1 then Iff(pvar x 0, pvar y 0)
           else And(Iff(pvar x (i-1), pvar y (i-1)), allequal x y (i-1));;
               
let associative =
  Imp(
    And(
      And(adder1, adder2), 
      And(
        And(Not(p "CXY_0"),Not(p "CXYZ1_0")),
        And(Not(p "CYZ_0"),Not(p "CXYZ2_0")))),
      (allequal "XYZ1" "XYZ2" bvsize));;

dplbtaut associative;;

let rec limboole f =
  match f with
    Atom(P(x)) -> x
  | Not(f0) -> "(!" ^ (limboole f0) ^ ")"
  | And(f1,f2) -> "(" ^ (limboole f1) ^ "&" ^ (limboole f2) ^ ")"
  | Or(f1,f2) ->  "(" ^ (limboole f1) ^ "|" ^ (limboole f2) ^ ")"
  | Imp(f1,f2) -> "(" ^ (limboole f1) ^ "->" ^ (limboole f2) ^ ")"
  | Iff(f1,f2) -> "(" ^ (limboole f1) ^ "<->" ^ (limboole f2) ^ ")"
  | _ -> failwith "unsupported formula"
;;

print_string (limboole associative);;