(* WS: convenience function not in Harrison's book *)
let unification_result fm1 fm2 =
  let fv = setify (fvt fm1)@(fvt fm2) in
  let i = fullunify [fm1,fm2] in
  let f x = if defined i x then [x,apply i x] else [] in
  setify (List.concat (map f fv))
;;

unification_result <<|f(x,y)|>> <<|f(y,x)|>> ;;

unification_result <<|f(x,g(y))|>> <<|f(f(z),w)|>> ;;

unification_result <<|f(x,g(a()),g(z))|>> <<|f(g(y),g(y),g(g(x)))|>> ;;

(* unification_result <<|f(x,g(y))|>> <<|f(y,x)|>> ;; *)

prawitz << (P(a) \/ Q(b)) /\ (forall x. P(x) ==> R(x)) /\ (forall x. Q(x) ==> R(f(x))) 
    ==> (exists x. R(x)) >>;;
    
let p43 = davisputnam
 <<(forall x y. Q(x,y) <=> forall z. P(z,x) <=> P(z,y))
   ==> forall x y. Q(x,y) <=> Q(y,x)>>;;
   
let p43 = prawitz
 <<(forall x y. Q(x,y) <=> forall z. P(z,x) <=> P(z,y))
   ==> forall x y. Q(x,y) <=> Q(y,x)>>;;
  
let mine = tab << (P(a) \/ Q(b)) /\ (forall x. P(x) ==> R(x)) /\ (forall x. Q(x) ==> R(f(x))) 
    ==> (exists x. R(x)) >>;;

let p38 = tab
 <<(forall x.
     P(a) /\ (P(x) ==> (exists y. P(y) /\ R(x,y))) ==>
     (exists z w. P(z) /\ R(x,w) /\ R(w,z))) <=>
   (forall x.
     (~P(a) \/ P(x) \/ (exists z w. P(z) /\ R(x,w) /\ R(w,z))) /\
     (~P(a) \/ ~(exists y. P(y) /\ R(x,y)) \/
     (exists z w. P(z) /\ R(x,w) /\ R(w,z))))>>;;
     
(* does not terminate after one minute *)
(* let p38 = prawitz << ... >> ;; *)

(* does not terminate after one minute *)
(*
let ewd1062 = tab
 <<(forall x. x <= x) /\
   (forall x y z. x <= y /\ y <= z ==> x <= z) /\
   (forall x y. f(x) <= y <=> x <= g(y))
   ==> (forall x y. x <= y ==> f(x) <= f(y)) /\
       (forall x y. x <= y ==> g(x) <= g(y))>>;;
*)

let ewd1062 = splittab
 <<(forall x. x <= x) /\
   (forall x y z. x <= y /\ y <= z ==> x <= z) /\
   (forall x y. f(x) <= y <=> x <= g(y))
   ==> (forall x y. x <= y ==> f(x) <= f(y)) /\
       (forall x y. x <= y ==> g(x) <= g(y))>>;;

