let print_sequent level key lfms rfms lats rats =
  print_newline();
  for i = 1 to level do print_string "  "; done;
  print_string key;
  forall (fun f -> print_prop_formula f ; true) (lfms@lats);
  print_string " |- ";
  forall (fun f -> print_prop_formula f ; true) (rfms@rats);
;;

let rec axiom lfms rfms lats rats level =
  (exists (fun lfm -> exists (fun rfm -> lfm=rfm) (rfms@rats)) (lfms@lats))
and lprove lfm lfms rfms lats rats level =
  match lfm with
    And(a,b) -> (gprove (a::b::lfms) rfms lats rats (level+1))
  | Or(a,b)  -> (gprove (a::lfms) rfms lats rats (level+1))
             && (gprove (b::lfms) rfms lats rats (level+1))
  | Imp(a,b) -> (gprove lfms (a::rfms) lats rats (level+1))
             && (gprove (b::lfms) rfms lats rats (level+1))
  | Not(a)   -> (gprove lfms (a::rfms) lats rats (level+1))
  | _        -> failwith "unsupported formula"
and rprove rfm lfms rfms lats rats level =
  match rfm with
    And(a,b) -> (gprove lfms (a::rfms) lats rats (level+1))
             && (gprove lfms (b::rfms) lats rats (level+1))
  | Or(a,b)  -> (gprove lfms (a::b::rfms) lats rats (level+1))
  | Imp(a,b) -> (gprove (a::lfms) (b::rfms) lats rats (level+1))
  | Not(a)   -> (gprove (a::lfms) rfms lats rats (level+1))
  | _        -> failwith "unsupported formula"
and gprove lfms rfms lats rats level =
  (axiom lfms rfms lats rats level) && 
  (print_sequent level "A:" lfms rfms lats rats; true)
|| match rfms with
   [] -> (match lfms with
           [] -> print_sequent level "F:" lfms rfms lats rats; false
         | lfm::lfms0 -> 
             (match lfm with
               Atom(_) -> (gprove lfms0 rfms (lfm::lats) rats level)
             | _ -> print_sequent level "L:" lfms rfms lats rats;
                    (lprove lfm lfms0 rfms lats rats level)))
   | rfm::rfms0 -> 
       match rfm with
         Atom(_) -> (gprove lfms rfms0 lats (rfm::rats) level)
         | _ -> print_sequent level "R:" lfms rfms lats rats;
                (rprove rfm lfms rfms0 lats rats level)
;;

let gprove f = gprove [] [f] [] [] 0 ;;

gprove << (p \/ q) /\ (p ==> r) /\ (~s ==> ~q) ==> r \/ s >> ;;
tautology << (p \/ q) /\ (p ==> r) /\ (~s ==> ~q) ==> r \/ s >> ;;

gprove << (p ==> q \/ r) /\ (r ==> s) ==> (p /\ q ==> s) >> ;;
tautology << (p ==> q \/ r) /\ (r ==> s) ==> (p /\ q ==> s) >> ;;

dptaut << (p ==> (q ==> r)) /\ (p ==> q) /\ p ==> r >> ;;
tautology << (p ==> (q ==> r)) /\ (p ==> q) /\ p ==> r >> ;;
gprove << (p ==> (q ==> r)) /\ (p ==> q) /\ p ==> r >> ;;
