% file fol6e-plus.p: every solution to the N queens problem has a symmetric solution
% (inspired by the TPTP problem PUZ133+2)
% solution with "succ" and "plus", run "vampire fol6e-plus.p"

% goal: "p is a solution /\ q is symmetric to p => q is a solution"
fof(goal, conjecture, (queens_p & symmetric_pq) => queens_q).
   
% p and q are solutions to the N queens problem
fof(queens_p, axiom, queens_p <=> 
  ![I,J]:((p(I) != p(J) & plus(p(I),I) != plus(p(J),J) & plus(p(I),J) != plus(p(J),I)))).
fof(queens_q, axiom, queens_q <=> 
  ![I,J]:((q(I) != q(J) & plus(q(I),I) != plus(q(J),J) & plus(q(I),J) != plus(q(J),I)))).

% definition of the index mapping: p(i) = q(n+1-i)
fof(symmetric, axiom, symmetric_pq <=>
  ![I]:(?[J]:(q(I) = p(J) & plus(I,J) = succ(n)))).
