% file fol6e-typed.p: every solution to the N queens problem has a symmetric solution
% (inspired by the TPTP problem PUZ133+2)
% typed solution, run "vampire --mode casc fol6e-typed.p"

tff(queens_p_type, type, queens_p: $o).
tff(queens_q_type, type, queens_q: $o).
tff(symmetric_pq_type, type, symmetric_pq: $o).
tff(p_type, type, p: $int > $int).
tff(q_type, type, q: $int > $int).
tff(n_type, type, n: $int).

% goal: "p is a solution /\ q is symmetric to p => q is a solution"
tff(goal, conjecture, (queens_p & symmetric_pq) => queens_q).
   
% p and q are solutions to the N queens problem
tff(queens_p, axiom, queens_p <=> % much faster with $lesseq and != than with $less
  ![I:$int,J:$int]:(($lesseq(1,I) & $lesseq(I,J) & $lesseq(J,n) & I != J) => 
    (p(I) != p(J) & $sum(p(I),I) != $sum(p(J),J) & $sum(p(I),J) != $sum(p(J),I)))).
tff(queens_q, axiom, queens_q <=> % much faster with $lesseq and != than with $less
  ![I:$int,J:$int]:(($lesseq(1,I) & $lesseq(I,J) & $lesseq(J,n) & I != J) => 
    (q(I) != q(J) & $sum(q(I),I) != $sum(q(J),J) & $sum(q(I),J) != $sum(q(J),I)))).

% definition of the index mapping: q(i) = p(pos(i)) = p(n+1-i)
tff(symmetric, axiom, symmetric_pq <=> 
  ![I:$int]:(($lesseq(1,I) & $lesseq(I,n)) => q(I)=p($difference($sum(n,1),I)))).

