public class Sudoku
{
	private static final int M=3;
	private static final int N=M*M;
	
	public static void main(String[] args)
	{
		someNumber(); and(); notMultipleNumbers(); and();
		rowConditions(); and(); columnConditions(); and(); tileConditions();
	}
	
	private static void or() { System.out.print("|"); }
	private static void and() { System.out.print("&"); }
	private static void not() { System.out.print("!"); }
	private static void open() { System.out.print("("); }
	private static void close() { System.out.print(")"); }
	
	// field (i,j) has number v
	private static void entry(int i, int j, int v)
	{
		System.out.print("cell_" + i + "_" + j + "_value_" + (v+1));
	}
	
	// entry (i1,j1) has number v1 and entry (i2,j2) has entry v2,
  private static void entries(int i1, int j1, int v1, int i2, int j2, int v2)
	{
		open(); entry(i1,j1,v1); and(); entry(i2,j2,v2); close();
	}
	
	// every entry has some number
	private static void someNumber()
	{
		for (int i = 0; i < N; i++)
		{
			for (int j = 0; j < N; j++)
			{
				open();
				for (int v = 0; v < N; v++) { entry(i,j,v); if (v+1 < N) or(); }
				close();
				if (i+1 < N || j+1 < N) and();
			}
	  }
	  System.out.println();
	}
	
	// no entry has multiple numbers
  private static void notMultipleNumbers()
	{
		for (int i = 0; i < N; i++)
		{
			for (int j = 0; j < N; j++)
			{
				for (int v1 = 0; v1 < N-1; v1++) 
			  { 
			  	for (int v2 = v1+1; v2 < N; v2++) 
			  	{
			  		not(); entries(i,j,v1,i,j,v2);
			  		if (i+1 < N || j+1 < N || v1+1 < N-1 || v2+1 < N) and();
			    }
			  }
			}
	  }
	  System.out.println();
	}
		
	// no number occurs twice in a row
  private static void rowConditions()
	{
		for (int i = 0; i < N; i++)
		{
		  for (int j1 = 0; j1 < N-1; j1++)
			{
				for (int j2 = j1+1; j2 < N; j2++) 
			  { 
			  	for (int v = 0; v < N; v++) 
			  	{
			  		not(); entries(i,j1,v,i,j2,v);
			  		if (i+1 < N || j1+1 < N-1 || j2+1 < N || v+1 < N) and();
			    }
			  }
			}
	  }
	  System.out.println();
	}
	
  // no number occurs twice in a column
  private static void columnConditions()
	{
		for (int i = 0; i < N; i++)
		{
		  for (int j1 = 0; j1 < N-1; j1++)
			{
				for (int j2 = j1+1; j2 < N; j2++) 
			  { 
			  	for (int v = 0; v < N; v++) 
			  	{
			  		not(); entries(j1,i,v,j2,i,v);
			  		if (i+1 < N || j1+1 < N-1 || j2+1 < N || v+1 < N) and();
			    }
			  }
			}
	  }
	  System.out.println();
	}
	
	// no number occurs twice in a tile
	private static void tileConditions()
	{
		for (int i = 0; i < M; i++)
		{
			for (int j = 0; j < M; j++)
			{
				for (int v = 0; v < N; v++)
				{
					for (int k1 = 0; k1 < N-1; k1++)
					{
						for (int k2 = k1+1; k2 < N; k2++)
						{
							int k1i = k1/M; int k1j = k1%M;
							int k2i = k2/M; int k2j = k2%M;
							not(); entries(i*M+k1i,j*M+k1j,v,i*M+k2i,j*M+k2j,v);
							if (i+1 < M || j+1 < M || v+1 < N || k1+1 < N-1 || k2+1 < N) and();
						}
					}
				}
			}
		}
		System.out.println();
	}
}