%% file fol4.pl with predicate add(X,Y,Z) interpreted as "adding X and Y gives Z".
add(X,zero,X).                        %% adding X and zero gives X.
add(X,succ(Y),succ(Z)) :- add(X,Y,Z). %% adding X and Y+1 gives Z+1, if adding X and Y gives Z.

%% sample queries
%% add(succ(zero),succ(succ(zero)),Z).
%% add(succ(zero),Y,succ(succ(succ(zero)))).
%% add(X,Y,succ(succ(succ(zero)))).

append([],Ys,Ys).
append([X|Xs],Ys,[X|Zs]) :- append(Xs,Ys,Zs).

partition([X|Xs],Y,[X|Ls],Rs) :-
  X =< Y, partition(Xs,Y,Ls,Rs).
partition([X|Xs],Y,Ls,[X|Rs]) :-
  X > Y, partition(Xs,Y,Ls,Rs).
partition([],Y,[],[]).

quicksort([X|Xs],Ys) :-
  partition(Xs,X,Left,Right),
  quicksort(Left,Ls),
  quicksort(Right,Rs),
  append(Ls,[X|Rs],Ys).
quicksort([],[]).

%% quicksort([3,1,4,1,5,9,2,7],X).