package linsearch;

public class Main
{
  /*@ requires a != null;
    @ assignable \nothing;
    @ ensures 
    @   (\result == -1 && 
    @     (\forall int j; 0 <= j && j < a.length; a[j] != x)) ||
    @   (0 <= \result && \result < a.length && a[\result] == x &&
    @     (\forall int j; 0 <= j && j < \result; a[j] != x));
    @*/
  public static int search(int[] a, int x)
  {
    int n = a.length;
    int i = 0;
    int r = -1;
    /*@ loop_invariant
      @   a != null && n == a.length && 
      @   0 <= i && i <= n &&
      @   (\forall int j; 0 <= j && j < i-1; a[j] != x) &&
      @   (r == -1 && i > 0 ==> a[i-1] != x) &&
      @   (r == -1 || (r == i-1 && 0 < i && a[r] == x));
      @ assignable r, i;
      @ decreases n-i;
      @*/
    while (i < n && r == -1)
    {
      if (a[i] == x) 
        r = i;
      i = i+1;
    }
    return r;
  }
}
