package linsearch;

public class Main0
{
  /*@ requires a != null;
    @ assignable \nothing;
    @ ensures 
    @   (\result == -1 && 
    @     (\forall int j; 0 <= j && j < a.length; a[j] != x)) ||
    @   (0 <= \result && \result < a.length && a[\result] == x &&
    @     (\forall int j; 0 <= j && j < \result; a[j] != x));
    @*/
  public static int search(int[] a, int x)
  {
    int n = a.length;
    int i = 0;
    int r = -1;
    /*@ loop_invariant
      @   a != null && n == a.length &&
      @   0 <= i && i <= n &&
      @   (\forall int j; 0 <= j && j < i; a[j] != x) &&
      @   (r == -1 || (r == i && i < n && a[i] == x));
      @ decreases r == -1 ? n-i : 0;
      @ assignable r, i;
      @*/
    while (r == -1 && i < n)
    {
      if (a[i] == x) 
        r = i;
      else
        i = i+1;
    }
    return r;
  }
}
