class IntStack
{
  /*@ non_null @*/ private int[] stack;
  private int number; 

  /*@ private invariant 0 <= number && number <= stack.length; @*/

  /*@ private constraint 
    @  (\forall int i; 0 <= i && i < number-1; stack[i] == \old(stack[i]));
    @*/

  private final int N = 10;

  /*@ private normal_behavior
    @ assignable stack, number;
    @ ensures stack.length == N;
    @ ensures isempty();
    @*/
  public IntStack() 
  { 
    stack = new int[N]; 
    number = 0; 
  }

  /*@ private normal_behavior
    @ ensures \result <==> number == 0;
    @*/
  /*@ pure @*/ public boolean isempty()
  { 
    return number == 0; 
  }

  /*@ private normal_behavior
    @ assignable stack[*], number, stack;
    @ ensures number == \old(number)+1;
    @ ensures stack[\old(number)] == e;
    @*/
  public void push(int e) 
  { 
    if (number == stack.length) 
      resize();
    stack[number] = e;
    number = number+1;
  }

  /*@ private normal_behavior
    @ requires !isempty();
    @ assignable number;
    @ ensures number == \old(number)-1;
    @ ensures \result == stack[number];
    @*/
  public int pop()
  {
    number = number-1;
    return stack[number];
  }

  /*@ private normal_behavior
    @ assignable stack;
    @ ensures number < stack.length;
    @ ensures \fresh(stack);
    @ ensures (\forall int i; 0 <= i && i < \old(stack.length);
    @            stack[i] == \old(stack[i]));
    @*/
  private void resize()
  {
     int s[] = new int[2*stack.length+1];
     for (int i=0; i<stack.length; i++) 
       s[i] = stack[i];
     stack = s;
  }
}
