class Bag {
  public int[] a;
  public int n;

  /*@ public invariant a != null; 
    @ public invariant 0 <= n && n <= a.length;
    @ public invariant (\forall int i; 0 <= i && i < n; 
    @                    a[i] <= Integer.MAX_VALUE);
    @*/
    
  /*@ public normal_behavior
    @ requires input != null;
    @ requires (\forall int i; 0 <= i && i < input.length; 
    @             input[i] <= Integer.MAX_VALUE);
    @ assignable n, a;
    @ ensures n == input.length;
    @ ensures n == a.length;
    @ ensures (\forall int i; 0 <= i && i < n; a[i] == input[i]);
    @*/
  public Bag(int[] input) {
    n = input.length;
    a = new int[n];
    // System.arraycopy(input, 0, a, 0, n);
    for (int i=0; i<n; i++) a[i] = input[i];
  }

  /*@ public normal_behavior
    @ requires n > 0;
    @ assignable n, a[*];
    @ ensures (\forall int i; 0 <= i && i < \old(n); \result <= \old(a[i]));
    @ ensures (\exists int i; 0 <= i && i < \old(n); 
    @             \result == \old(a[i]) &&
    @             a[i] == \old(a[n-1]) &&
    @             (\forall int j; 0 <= j && j < \old(n) && j != i;
    @                a[j] == \old(a[j])));
    @ ensures n == \old(n)-1;
    @*/
  public int extractMin() {
    int m = Integer.MAX_VALUE;
    int mindex = 0;
    for (int i = 0; i < n; i++) {
      if (a[i] < m) {
        mindex = i;
        m = a[i];
      }
    }
    n--;
    a[mindex] = a[n];
    return m;
  }
}
